Use ConvertTmp
truncate table tblOxy
truncate table tblTemp
truncate table tblSalt
truncate table tblStation

BULK INSERT tblOxy FROM 'd:\TmpShared\ru\oxygen.csv' WITH (FIRSTROW=1,FIELDTERMINATOR = ',',ROWTERMINATOR = '\n');
BULK INSERT tblTemp FROM 'd:\TmpShared\ru\temperature.csv' WITH (FIRSTROW=1,FIELDTERMINATOR = ',',ROWTERMINATOR = '\n');
BULK INSERT tblSalt FROM 'd:\TmpShared\ru\salinity.csv' WITH (FIRSTROW=1,FIELDTERMINATOR = ',',ROWTERMINATOR = '\n');
BULK INSERT tblStation FROM 'd:\TmpShared\ru\station.csv' WITH (FIRSTROW=2,FIELDTERMINATOR = ',',ROWTERMINATOR = '\n');



--select Data
--select top 10 * from tblStation
set dateformat dmy
SELECT * FROM tblStation ST LEFT JOIN 
tblTemp T ON T.StnID=ST.StnID LEFT Join 
tblSalt S ON S.StnID=ST.StnID AND S.Depth=T.Depth Left JOIN 
tblOxy O ON O.StnID=ST.StnID AND O.Depth=T.Depth
where ST.stnID<10 Order by cast(ST.[Date] as datetime), ST.[Time], St.StnID, cast(t.Depth as float)

--Do the Mumbo Jumbo
-- SEPARATE FIELDS
--bcp "SELECT Ship, Lat, Lon, [Date], [Time], Sound, T.Depth, T.Value as T, S.Value as S, O.value as O FROM ConvertTmp..tblStation ST LEFT JOIN ConvertTmp..tblTemp T ON T.StnID=ST.StnID LEFT Join ConvertTmp..tblSalt S ON S.StnID=ST.StnID AND S.Depth=T.Depth Left JOIN ConvertTmp..tblOxy O ON O.StnID=ST.StnID AND O.Depth=T.Depth Order by cast(ST.[Date] as datetime), ST.[Time], St.StnID, cast(t.Depth as float)" queryout "Merged.csv" -c -q -SOWL -Uweb -Pwebaccess
--Or run this from Query Analyuser with output to file
SELECT Ship, Lat, Lon, [Date], [Time], Sound, T.Depth, T.Value as T, S.Value as S, O.value as O FROM tblStation ST LEFT JOIN 
tblTemp T ON T.StnID=ST.StnID LEFT Join 
tblSalt S ON S.StnID=ST.StnID AND S.Depth=T.Depth Left JOIN 
tblOxy O ON O.StnID=ST.StnID AND O.Depth=T.Depth
Order by cast(ST.[Date] as datetime), ST.[Time], St.StnID, cast(t.Depth as float)

--ONE csv FIELD 
--bcp "use ConvertTmp; SELECT RTRIM(Ship)+','+RTRIM(Lat)+','+RTRIM(Lon)+','+[Date]+','+RTRIM([Time])+','+RTRIM(Sound)+','+RTRIM(T.Depth)+','+isnull(RTRIM(T.Value),'-9')+','+ isnull(RTRIM(S.Value),'-9')+','+ISNULL(RTRIM(O.value),'-9') FROM tblStation ST LEFT JOIN tblTemp T ON T.StnID=ST.StnID LEFT Join tblSalt S ON S.StnID=ST.StnID AND S.Depth=T.Depth Left JOIN tblOxy O ON O.StnID=ST.StnID AND O.Depth=T.Depth Order by cast(ST.[Date] as datetime), ST.[Time], St.StnID, cast(t.Depth as float)" queryout "Merged.csv" -c -q -SOWL -Uweb -Pwebaccess
SELECT RTRIM(Ship)+','+cast((cast(St.StnID as int)%10000) as varchar(4))+','+RTRIM(Lat)+','+RTRIM(Lon)+','+[Date]+','+RTRIM([Time])+','+RTRIM(Sound)+','+RTRIM(T.Depth)+','+isnull(RTRIM(T.Value),'-9')+','+ isnull(RTRIM(S.Value),'-9')+','+ISNULL(RTRIM(O.value),'-9') FROM tblStation ST LEFT JOIN 
tblTemp T ON T.StnID=ST.StnID LEFT Join 
tblSalt S ON S.StnID=ST.StnID AND S.Depth=T.Depth Left JOIN 
tblOxy O ON O.StnID=ST.StnID AND O.Depth=T.Depth
Order by cast(ST.[Date] as datetime), ST.[Time], St.StnID, cast(t.Depth as float)






--Make sure that there is no data without station info
Select * from tblTemp T Where not exists(SELECT StnID FROM tblStation S WHERE S.StnID=T.StnID)
Select * from tblSalt S Where not exists(SELECT StnID FROM tblStation ST WHERE ST.StnID=S.StnID)
Select * from tblOxy O Where not exists(SELECT StnID FROM tblStation S WHERE S.StnID=O.StnID)
--There is not.
--Check that StationID is unique
select StnID, count(StnID) from tblStation group by StnID having count(StnID) > 1 
--It is.


-- Merge ship names with shipcodes, info from S:\ru\new\842\convert\shipn2c.txt
select top 10 * from tblstation WHERE cast([Date] as datetime)>'01/01/1992'
